package editor;

import game.CustomImageDataII;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class PreviewCanvas extends JPanel {
	
	private boolean useDefaultImageDimensions;
	
	private BufferedImage currentPreviewImage;
	
	private ListedCustomImage rawImageData;
	
	private int currentWidth;
	private int currentHeight;
	private Color currentTransparentColor;
	private int currentTransparency = -1;
	
	private Image backdropImage;
	
	private ImageObserver imageObserver;
	
	private boolean isBackdrop;
	
	public PreviewCanvas(boolean defaultDimensions, ImageObserver obs, boolean shouldBeBackdrop) {
		
		super();
		
		useDefaultImageDimensions = defaultDimensions;
		imageObserver = obs;
		isBackdrop = shouldBeBackdrop;
		
		Border border = BorderFactory.createLineBorder(new Color(0,0,0));
		
		this.setBorder(border);
		
		this.setPreferredSize(new Dimension(200, 200));
		this.setMinimumSize(new Dimension(200, 200));
		this.setMaximumSize(new Dimension(200, 200));
		
		rawImageData = null;
		
		backdropImage = (new ImageIcon(PreviewCanvas.class.getResource("/images/silver_white_check.GIF"))).getImage();
		
	}
	
	public void paintComponent(Graphics g) {
		
//		System.out.println("just entered paintComponent; is the backdrop image null?  " + (backdropImage == null) + "; is current preview image null? " + (currentPreviewImage == null) + ", and useDefaultImageDimensions is: " + useDefaultImageDimensions);
		
		Color originalColor = g.getColor();
		
		if(currentPreviewImage == null) {
			if(backdropImage != null) {
				g.drawImage(backdropImage, 0, 0, 200, 200, imageObserver);
//				System.out.println("backdropImage should be on-screen, at this point...");
			} else {
				Color origColor = g.getColor();
				g.setColor(new Color(255,255,255,255));
				g.fillRect(0, 0, 200, 200);
				g.setColor(origColor);
			}
		} else if(currentTransparency == -1) {
			if(useDefaultImageDimensions) {
				
//				System.out.println("about to paint currentPreviewImage");
				g.drawImage(currentPreviewImage, 0, 0, 200, 200, null);
				
			} else {
				
				
//				System.out.println("NOT about to paint currentPreviewImage");
				
				int newHeight, newWidth, newX, newY;
				
				double ratioOfWidthToHeight = ((double) currentWidth) / ((double) currentHeight);
				
				if(currentHeight >= currentWidth) {
					
					newHeight = 200;
					newWidth = (int) (ratioOfWidthToHeight * 200.0);
					
					newY = 0;
					newX = 100 - (newWidth / 2);
					
				} else {
					
					newWidth = 200;
					newHeight = (int) (200.0 / ratioOfWidthToHeight);
					
					newX = 0;
					newY = 100 - (newHeight / 2);
					
				}
				

//				System.out.println("now in the else-block of PreviewCanvas:  newX is: " + newX + ", newY is: " + newY + ", newWidth is: " + newWidth + ", newHeight is: " + newHeight + ", original width is: " + currentWidth + ", height: " + currentHeight + ";  backdropImage is null: " + backdropImage + ", ratio: " + ratioOfWidthToHeight);
			
				
				if(backdropImage != null) {
					g.drawImage(backdropImage, 0, 0, 200, 200, imageObserver);
//					System.out.println("just drew the backdropImage...");
				}
				
//				System.out.println("2222 is backdropImage null? " + (backdropImage == null) + ", an is rawImageData? " + (rawImageData == null));
				
				if(!isBackdrop) {
					Image traspentedImage = null;
					if(rawImageData != null) {
//						System.out.println("1 rawImageData was non-null");
						traspentedImage = CustomImageDataII.makeImageTransparent(CustomImageDataII.createClone(rawImageData.getImage(), this), currentTransparentColor);
					} else {
//						System.out.println("1 rawImageData was null!  is currentPreviewImage? " + (currentPreviewImage == null));
						traspentedImage = CustomImageDataII.makeImageTransparent(CustomImageDataII.createClone(currentPreviewImage, this), currentTransparentColor);
					}
					
					g.drawImage(traspentedImage, newX, newY, newWidth, newHeight, null);
				} else {
					g.drawImage(currentPreviewImage, newX, newY, newWidth, newHeight, null);
				}
			}
		} else {
			
			
			
			
			if(useDefaultImageDimensions) {
				
//				System.out.println("hmm, none of the above and useDefaultImageDimensions");
				g.drawImage(currentPreviewImage, 0, 0, 200, 200, null);
				
			} else {
				
//				System.out.println("hmm, none of the above and NOT useDefaultImageDimensions");
				
				
				int newHeight, newWidth, newX, newY;
				
				double ratioOfWidthToHeight = ((double) currentWidth) / ((double) currentHeight);
				
				if(currentHeight >= currentWidth) {
					
					newHeight = 200;
					newWidth = (int) (ratioOfWidthToHeight * 200.0);
					
					newY = 0;
					newX = 100 - (newWidth / 2);
					
				} else {
					
					newWidth = 200;
					newHeight = (int) (200.0 / ratioOfWidthToHeight);
					
					newX = 0;
					newY = 100 - (newHeight / 2);
					
				}
				

//				System.out.println("now in the else-block of PreviewCanvas:  newX is: " + newX + ", newY is: " + newY + ", newWidth is: " + newWidth + ", newHeight is: " + newHeight + ", original width is: " + currentWidth + ", height: " + currentHeight + ";  backdropImage is null: " + backdropImage);
				
				if(backdropImage != null) {
					g.drawImage(backdropImage, 0, 0, 200, 200, imageObserver);
//					System.out.println("just drew the backdropImage...");
				}
				
//				System.out.println("backdropImage == null? " + (backdropImage == null) + "...and rawImageData == null? " + (rawImageData == null));
				
				Image traspentedImage = null;
				if(rawImageData != null) {
//					System.out.println("2 rawImageData was non-null!");
					traspentedImage = CustomImageDataII.makeImageTransparent(CustomImageDataII.createClone(rawImageData.getImage(), this), currentTransparentColor);
				} else {
//					System.out.println("2 rawImageData was null!");
					traspentedImage = CustomImageDataII.makeImageTransparent(CustomImageDataII.createClone(currentPreviewImage, this), currentTransparentColor);
				}
				
				Composite origComposite = ((Graphics2D) g).getComposite();
				((Graphics2D)g).setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, currentTransparency / 255.0f));
				
				g.drawImage(traspentedImage, newX, newY, newWidth, newHeight, null);

				((Graphics2D)g).setComposite(origComposite);
				
				
			}
			
		}
		
		g.setColor(originalColor);
		
	}
	
	public void setListedImage(BufferedImage newImage) {
		currentPreviewImage = newImage;
		if(newImage == null)
			rawImageData = null;
		
//		System.out.println("is newImage null? " + (newImage == null));
		
		if(newImage != null) {
			currentHeight = newImage.getHeight();
			currentWidth = newImage.getWidth();
		}
	}
	
	public void refresh() {
		this.repaint();
	}
	
	public void setNewParms(ListedCustomImage newCurrent) {
		
		currentHeight = newCurrent.getDesiredHeight();
		currentWidth = newCurrent.getDesiredWidth();
		currentTransparentColor = newCurrent.getTransparentColor();
		rawImageData = newCurrent;
		
		if(newCurrent instanceof ListedOverlayImage) {
			currentTransparency = ((ListedOverlayImage) newCurrent).getTransparency();
		} else {
			currentTransparency = -1;
		}
		
	}

	public Image getBackdropImage() {
		return backdropImage;
	}

	public void setBackdropImage(Image backdropImage) {
		this.backdropImage = backdropImage;
	}
	
	
}
